#include <string.h>
#include <stdio.h>
#include "helper.h"
#include "boundary_val.h"

void  boundaryvalues(int wl, int wr, int wt, int wb,
	       int imax,
	       int jmax,
	       double **U,
	       double **V,
	       int **Flag)
{
  int i,j;
  int f;

/* left boundary */

  switch( wl ){
    case 1: for(j=1;j<=jmax;j++){ U[0][j] = 0;        V[0][j] = -V[1][j];  } break;
    case 2: for(j=1;j<=jmax;j++){ U[0][j] = 0;        V[0][j] =  V[1][j];  } break;
    case 3: for(j=1;j<=jmax;j++){ U[0][j] = U[1][j];  V[0][j] =  V[1][j];  } break;
    case 4: for(j=1;j<=jmax;j++){ U[0][j] = U[1][j];  V[0][j] =  V[1][j];  } break;
  }

/* right boundary */

  switch( wr ){
    case 1: for(j=1;j<=jmax;j++){ U[imax][j] = 0;   V[imax+1][j] = -V[imax][j];}
    case 2: for(j=1;j<=jmax;j++){ U[imax][j] = 0;   V[imax+1][j] =  V[imax][j];}
    case 3: for(j=1;j<=jmax;j++){ U[imax][j] = U[imax-1][j];V[imax+1][j] =  V[imax][j];}
    case 4: for(j=1;j<=jmax;j++){ U[imax][j] = U[imax-1][j];V[imax+1][j] =  V[imax][j];}
  }

/* top */

  switch( wt ){
    case 1: for(i=1;i<=imax;i++){ V[i][jmax] = 0;   U[i][jmax+1] = -U[i][jmax]; }
    case 2: for(i=1;i<=imax;i++){ V[i][jmax] = 0;   U[i][jmax+1] =  U[i][jmax]; }
    case 3: for(i=1;i<=imax;i++){ V[i][jmax] = V[i][jmax-1];U[i][jmax+1] =  U[i][jmax]; }
  }

/* bottom */

  switch( wb ){
    case 1: for(i=1;i<=imax;i++){ V[i][0] = 0;        U[i][0] = -U[i][1]; }
    case 2: for(i=1;i<=imax;i++){ V[i][0] = 0;        U[i][0] =  U[i][1]; }
    case 3: for(i=1;i<=imax;i++){ V[i][0] = V[i][1];  U[i][0] =  U[i][1]; }
  }


  for(i=1;i<=imax;i++){
    for(j=1;j<=jmax;j++){
      f = Flag[i][j];
      if( (f&C_TYP)==C_B ){

	if(           (f&C_H) == C_N     )
	{
	  V[i][j] = 0;
	  U[i-1][j] = -U[i-1][j+1];
	  U[i][j]   = -U[i][j+1];
	}
	else if(      (f&C_H) == C_S     )
	{
	  V[i][j-1] = 0;
	  U[i-1][j] = -U[i-1][j-1];
	  U[i][j]   = -U[i][j-1];
	}
	else if(      (f&C_H) == C_W     )
	{
	  U[i-1][j] = 0;
	  V[i][j]   = -V[i-1][j];
	  V[i][j-1] = -V[i-1][j-1];
	}
	else if(      (f&C_H) == C_O     )
	{
	  U[i][j]   = 0;
	  V[i][j]   = -V[i+1][j];
	  V[i][j-1] = -V[i+1][j-1];
	}
	else if(      (f&C_H) == C_NO    )
	{
	  V[i][j]   = 0;
	  U[i][j]   = 0;
	  U[i-1][j] = -U[i-1][j+1];
	  V[i][j-1] = -V[i+1][j-1];
	}
	else if(      (f&C_H) == C_NW    )
	{
	  U[i-1][j] = 0;
	  V[i][j]   = 0;
	  U[i][j]   = -U[i][j+1];
	  V[i][j-1] = -V[i-1][j-1];
	}
        else if(      (f&C_H) == C_SO    )
	{
	  U[i][j]   = 0;
	  V[i][j-1] = 0;
	  U[i-1][j] = -U[i-1][j-1];
	  V[i][j]   = -V[i+1][j];
	}
	else if(      (f&C_H) == C_SW    )
	{
	  U[i-1][j] = 0;
	  V[i][j-1] = 0;
	  U[i][j]   = -U[i][j-1];
	  V[i][j]   = -V[i-1][j];
	}
	else if(      (f&C_H) == 0       )
	{
	  U[i][j] = U[i-1][j] = V[i][j] = V[i][j-1] = 0;
	}
      }
    }
  }

}


void spec_boundaryvalues(char *problem, int imax, int jmax, double **U, double **V)
{
  int i,j;

  if( strcmp(problem,"DrivenCavity") == 0 ){
    for(i=1;i<=imax;i++){
      V[i][jmax] = 0.0;
      U[i][jmax+1] = 2.0-U[i][jmax];
    }
  }

  else if( strcmp(problem,"step") == 0 ){
    for(j=jmax/2+1;j<=jmax;j++){
      U[0][j] = 1.0;
      V[0][j] = -V[1][j]; // left boundary inflow U=1, V=0
    }
  }


  else if( strcmp(problem,"karman") == 0 ||
	   strcmp(problem,"Cicle") == 0 ||
	   strcmp(problem,"Quadrat") == 0 ){
    for(j=1;j<=jmax;j++){
      U[0][j] = 1.0;
      V[0][j] = -V[1][j]; // left boundary inflow U=1, V=0 */
    }
    for(i=1;i<=imax;i++){
      U[i][jmax+1] = 2.0-U[i][jmax]; // no-slip top
      U[i][0] = 2.0-U[i][1]; // no-slip bottom
    }
  }

}

