#ifndef __RANDWERTE_H__
#define __RANDWERTE_H__


/**
 * According to the constants wl,rw,wt and wb the boundary values of the problem
 * are set. Here's the semantics of the constants:
 *
 *   1: no slip
 *   2: free slip
 *   3: outflow condition
 */
void boundaryvalues(int wl, int wr, int wt, int wb,
	       int imax,
	       int jmax,
	       double **U,
	       double **V,
	       int **Flag);

/**
 * This is a handcoded boundary specification operation, that is able to handle
 * several different application scenarios, e.g. the appropiate values for the
 * von Karman vortex street are set.
 */
void spec_boundaryvalues(char *problem, int imax, int jmax, double **U, double **V);

#endif
