#ifndef __INIT_H__
#define __INIT_H__


/**
 * This operation initializes all the local variables reading a configuration
 * file. For every variable a macro like READ_INT() is called passing it the
 * input filename and the variable to be written to. This macro calls
 * an operation read_int() augmenting the parameter set with the name of the
 * variable to be read. The read_int() operation parses the input file, extracts
 * the value of the variable, sets the variable and finally prints some debug
 * information. This is possible as the macro adds the name of the variable to
 * be set. All the helper operations can be found within helper.h and helper.c.
 *
 * @param szFileName char pointer to the filename
 * @param Re         Reynolds number
 * @param UI         initial velocity in  x-direction - used by init_uvp()
 * @param VI         initial velocity y-direction - used by init_upv()
 * @param PI         initial pressure - used by init_upv()
 * @param GX         gravitation x-direction
 * @param GY         gravitation y-direction
 * @param t_end      end time (not discrete in time steps)
 * @param xlength    domain length x-direction
 * @param ylength    domain lenght y-direction
 * @param dt         time step length: dividing t_end by dt gives the number of
 *                   time steps to perform. Actually dt is determined by a
 *                   function, so manipulating this value within the 
 *                   configuration file should not affect the solution process
 *                   at all
 * @param dx         cell length x-direction
 * @param dy         cell length y-direction
 * @param imax       number of cells in x-direction
 * @param jmax       number of cells in Y-direction
 * @param alpha      uppwind-differencing-factor alpha
 * @param omg        relaxation factor omega
 * @param tau        safety parameter for time step calculation
 * @param itermax    max. number of pressure iterations
 * @param eps        tolerance limit for pressure calculation
 * @param dt_value   time steps for output (after how many time steps one should
 *                   write into the output file)
 * @param problem    problem name (should be 'karman' for the Athens project)
 * @param wl         boundary value flags (left, right, top, bottom). Used within
 *                   operation boundaryvalues() in boundary_val.h. See operation
 *                   boundaryvalues() for constant semantics.
 * @param wr         boundary value flags (left, right, top, bottom). Used within
 *                   operation boundaryvalues() in boundary_val.h. See operation
 *                   boundaryvalues() for constant semantics.
 * @param wt         boundary value flags (left, right, top, bottom). Used within
 *                   operation boundaryvalues() in boundary_val.h. See operation
 *                   boundaryvalues() for constant semantics.
 * @param wb         boundary value flags (left, right, top, bottom). Used within
 *                   operation boundaryvalues() in boundary_val.h. See operation
 *                   boundaryvalues() for constant semantics.
 * @param dp         pressure difference (set to 0 in the Athens project)
 * @param N          number of particles on the line (x1,y1)_(x2,y2) (not needed)
 * @param x1
 * @param y1
 * @param x2
 * @param y2
 * @param dt_path   (not needed)
 * @param dt_streak (not needed)
 * @param dt_insert (not needed)
 */
int read_parameters( const char *szFileName,
                    double *Re,
                    double *UI,
                    double *VI,
                    double *PI,
                    double *GX,
                    double *GY,
                    double *t_end,
                    double *xlength,
                    double *ylength,
                    double *dt,
                    double *dx,
                    double *dy,
                    int  *imax,
                    int  *jmax,
                    double *alpha,
                    double *omg,
                    double *tau,
                    int  *itermax,
                    double *eps,
		    double *dt_value,
		    char *problem,
		    int *wl,
		    int *wr,
		    int *wt,
		    int *wb,
		    double *dp,
		    int *N,
		    double *x1,
		    double *y1,
		    double *x2,
		    double *y2,
		    double *dt_path,
		    double *dt_streak,
		    double *dt_insert);


void init_uvp(double UI,
	      double VI,
	      double PI,
	      int imax,
	      int jmax,
	      double **U,
	      double **V,
	      double **P);

void init_flag(char *problem,
	       int imax,
	       int jmax,
	       int **Flag);

#endif
