#include "helper.h"
#include "visual.h"
#include "init.h"
#include "boundary_val.h"
#include "uvp.h"
#include <stdio.h>


double Matrixtest(double **M, int i0, int i1, int j0, int j1)
{
  int i,j;
  double r = 0.0;
  for(j=j1;j>=j0;j--){
    for(i=i0;i<=i1;i++){

      printf("   %8.5f",M[i][j]);
      fflush(stdout);

      r += M[i][j]*M[i][j];
    }

    printf("\n");

  }
  printf("   %8.5f\n",r);
  fflush(stdout);
  return r;
}



/**
 * The main operation reads the configuration file, initializes the scenario and
 * contains the main loop. For a description of the local variables see either
 * the comments here, the comments within the input file or the documentation of
 * the operation read_parameters(). So here are the individual steps of the
 * algorithm:
 *
 * - read the program configuration file: read_parameters()
 * - set up the matrices (arrays) needed using the matrix() command
 * - create the initial setup init_uvp(), init_flag(), output_uvp()
 * - perform the main loop
 * - trailer: destroy memory allocated and do some statistics
 *
 * The layout of the grid is decribed by the first figure below, the enumeration
 * of the whole grid is given by the second figure. All the unknowns corresond
 * to a two dimensional degree of freedom layout, so they are not stored in
 * arrays, but in a matrix.
 *
 * @image html grid.jpg
 *
 * @image html whole-grid.jpg
 *
 * Within the main loop the following big steps are done:
 *
 * - calculate_dt() Determine the maximal time step size.
 * - boundaryvalues() Set the boundary values for the next time step.
 * - spec_boundaryvalues() Set the problem specific boundary values.
 * - calculate_fg() Determine the values of F and G (diffusion and confection).
 *   This is the right hand side of the pressure equation and used later on for
 *   the time step transition.
 * - calculate_rs()
 * - Iterate the pressure poisson equation until the residual becomes smaller
 *   than eps or the maximal number of iterations is performed. Within the
 *   iteration loop the operation sor() is used.
 * - calculate_uv() Calculate the velocity at the next time step.
 */
int main(int argn, char** args){

  double xlength;           /* size of the region in x-direction */
  double ylength;           /* size of the region in y-direction */
  int imax;                 /* number of cells in x-direction */
  int jmax;                 /* number of cells in y-direction */
  double dx;                /* length  in x-direction */
  double dy;                /* length  in y-direction */

  double t;                 /* current time */
  double t_end;             /* end time */
  double dt;                /* time step size */
  double tau;               /* user defined parameter used in calculation
                               of time step size */

  double dp;             /* pressure difference */
  double dt_value;          /* time interval for output */

  int itermax;              /*  user defined max. number of SOR iterations
                                for the pressure calculation */
  int it;
  int n;
  double res;
  double eps;               /* user defined tolerance value for SOR */
  double omg;               /* relaxation parameter omega */
  double alpha;             /* uppwind differencing parameter alpha */

  double Re;                   /* Reynoldsnumer */
  double GX,GY;                /* gravitation constants  */
  double UI,VI,PI;             /* initial values for U,V,P */

  double **U, **V, **P, **RS, **F, **G;

  int **Flag;

  double t_mod_dt_value;
  double dt_orig;

  char problem[80];    /*the name of the problem*/
  int wl,wr,wt,wb;     /*boundary values types left right top bottom*/

  char inputfilename[80];

  struct particle_line *Pathlines;
  struct particle_line *Streaklines;
  int N;
  double x1,y1,x2,y2;
  double dt_streak = 0.0;
  double dt_path    = 0.0;
  double dt_insert= 0.0;
  char pathfilename[80];
  char streakfilename[80];

  if(argn<2){
    printf("Usage: sim inputfile (the extension .dat will be added automatically !)\n");
    exit(0);
  }

  sprintf( inputfilename, "%s.dat", args[1] );

  read_parameters(inputfilename,
                 &Re,    &UI,&VI,&PI,   &GX,&GY,  &t_end,&xlength,&ylength,
                 &dt,&dx,&dy,  &imax,&jmax,   &alpha,&omg,&tau,
                 &itermax,&eps,&dt_value,problem,&wl,&wr,&wt,&wb,&dp,
                 &N, &x1, &y1, &x2, &y2,
                 &dt_path, &dt_streak, &dt_insert );

  dt_orig = dt;

  U = matrix(0,imax+1,0,jmax+1);
  V = matrix(0,imax+1,0,jmax+1);
  P = matrix(0,imax+1,0,jmax+1);
  F = matrix(0,imax  ,1,jmax  );
  G = matrix(1,imax  ,0,jmax  );
  RS= matrix(0,imax  ,0,jmax  );
  Flag = imatrix(0,imax+1,0,jmax+1);

/*  if(dt_path>0.0){
    sprintf( pathfilename, "%s.path", args[1] );
    Pathlines = set_particle(N,x1,y1,x2,y2,xlength,ylength,pathfilename);
  }
  if(dt_streak>0.0){
    sprintf( streakfilename, "%s.streak", args[1] );
    Streaklines = set_particle(N,x1,y1,x2,y2,xlength,ylength,streakfilename);
  }*/
  t = 0;
  n = 0;

  printf("initial values for U, V und P...\n");
  init_uvp(UI,VI,PI,imax,jmax,U,V,P);
  init_flag(problem,imax,jmax,Flag);
  output_uvp(args[1],xlength,ylength,imax,jmax,dx,dy,U,V,P,Flag);

/*   printf("initial values U,V,P\n"); */
/*   printf("U\n");  Matrixtest(U,0,imax  ,0,jmax+1); */
/*   printf("V\n");  Matrixtest(V,0,imax+1,0,jmax  ); */
/*   printf("P\n");  Matrixtest(P,0,imax+1,0,jmax+1); */

  printf("begin the time loop...\n");

  while(t < t_end){


    printf("------------------------------------------------\n");
    printf("time         t  = %f\n",t);
    fflush(stdout);

    calculate_dt(Re,tau,&dt,dx,dy,imax,jmax,U,V);

    printf("time step  dt = %f\n",dt);

    boundaryvalues(wl,wr,wt,wb,imax,jmax,U,V,Flag);
    spec_boundaryvalues(problem,imax,jmax,U,V);
//    printf("C\n");  Matrixtest(C,0,imax+1,0,jmax+1);



    calculate_fg(Re,GX,GY,alpha,dt,dx,dy,imax,jmax,U,V,F,G,Flag);


    calculate_rs(dt,dx,dy,imax,jmax,F,G,RS);


    it = 0;
    res = eps+1;

    while(it<itermax && res > eps){

      sor(itermax,eps,omg,dx,dy,dp,imax,jmax,P,RS,Flag,&res);
      fflush(stdout);
      it++;

    }
    printf("number of iterations: %d\n",it);

/*    printf("P\n"); Matrixtest(P,0,imax+1,0,jmax+1);*/

    calculate_uv(dt,dx,dy,imax,jmax,U,V,F,G,P,Flag);

/*    printf("U\n"); Matrixtest(U,0,imax  ,0,jmax+1);*/

    t_mod_dt_value = t - ((int)(t/dt_value))*dt_value;

    if(t_mod_dt_value<dt){
      output_uvp(args[1],xlength,ylength,imax,jmax,dx,dy,U,V,P,Flag);
    }
/*
    if(dt_path>0.0){
             pathlines(Pathlines,N,dt_path,t,dx,dy,dt,imax,jmax,U,V,Flag,pathfilename);
    }
    if(dt_streak>0.0){
             streaklines(Streaklines,N,dt_insert,dt_streak,t,dx,dy,dt,imax,jmax,U,V,Flag,streakfilename);
    }
*/
    t += dt;
    n++;

    fflush(stdout);

  }
  output_uvp(args[1],xlength,ylength,imax,jmax,dx,dy,U,V,P,Flag);

  free_matrix(U,0,imax+1,0,jmax+1);
  free_matrix(V,0,imax+1,0,jmax+1);
  free_matrix(P,0,imax+1,0,jmax+1);
  free_matrix(F,0,imax  ,1,jmax  );
  free_matrix(G,1,imax  ,0,jmax  );
  free_matrix(RS,0,imax  ,0,jmax  );
  free_imatrix(Flag,0,imax+1,0,jmax+1);

  return 1;
}
