#include "helper.h"

void calculate_fg (double Re, double GX, double GY, double alpha,
                  double dt, double dx, double dy, int imax, int jmax,
                  double **U, double **V, double **F, double **G,int **Flag) 
{
    int    i, j, f;
    double d2udx2, d2udy2, du2dx, duvdy, d2vdx2, d2vdy2, duvdx, dv2dy;
    double tmp1, tmp2, tmp3, tmp4, tmp5, tmp6, tmp7, tmp8;

    double one_by_dxdx,one_by_dydy;

    one_by_dxdx = 1/dx/dx;
    one_by_dydy = 1/dy/dy;

    for(i=0; i<=imax; i++) {
      for(j=1; j<=jmax; j++) {

	f = Flag[i][j];

	/* 
	 *   if the cell is east fluid cell
	 *   
	 */
	if(  (f&C_TYP) == C_F   &&   (f&C_O) == C_O  ){  
	  
	  d2udx2 = (U[i+1][j] - 2 * U[i][j] + U[i-1][j])  * one_by_dxdx;
	  d2udy2 = (U[i][j+1] - 2 * U[i][j] + U[i][j-1])  * one_by_dydy;
	  
	  tmp1   = U[i][j] + U[i+1][j];
	  tmp2   = U[i-1][j] + U[i][j];
	  tmp3   = fabs(tmp1);
	  tmp4   = U[i][j]-U[i+1][j];
	  tmp5   = fabs(tmp2);
	  tmp6   = U[i-1][j] - U[i][j];
	  du2dx  = 0.25/dx * ( (tmp1*tmp1 - tmp2*tmp2) + alpha  * (tmp3*tmp4 - tmp5*tmp6) );

	  tmp1   = V[i][j] + V[i+1][j];
	  tmp2   = U[i][j] + U[i][j+1];
	  tmp3   = V[i][j-1] +V[i+1][j-1];
	  tmp4   = U[i][j-1] + U[i][j];
	  tmp5   = fabs(tmp1);
	  tmp6   = U[i][j] - U[i][j+1];
	  tmp7   = fabs(tmp3);
	  tmp8   = U[i][j-1] - U[i][j];
	  duvdy  = 0.25/dy * ( (tmp1*tmp2 - tmp3*tmp4) + alpha * (tmp5*tmp6 - tmp7*tmp8) );
	  
	  F[i][j] = U[i][j] + dt * 
	    ( 1/Re * (d2udx2 + d2udy2) - du2dx - duvdy + GX );

	}
	/*
	 *  otherwise
	 */
	else F[i][j] = U[i][j];
      }
    }


    for(i=1; i<=imax; i++) {
      for(j=0; j<=jmax; j++) {
	  
	f = Flag[i][j];
	
	/* 
	 *   north fluid cells 
	 */
	if(  (f&C_TYP) == C_F   &&   (f&C_N) == C_N  ){  
	  
	  d2vdx2 = (V[i+1][j] - 2 * V[i][j] + V[i-1][j]) * one_by_dxdx;
	  d2vdy2 = (V[i][j+1] - 2 * V[i][j] + V[i][j-1]) * one_by_dydy;
	  
	  tmp1   = U[i][j] + U[i][j+1];
	  tmp2   = V[i][j] + V[i+1][j];
	  tmp3   = U[i-1][j] + U[i-1][j+1];
	  tmp4   = V[i-1][j] + V[i][j];
	  tmp5   = fabs(tmp1);
	  tmp6   = V[i][j] - V[i+1][j];
	  tmp7   = fabs(tmp3); 
	  tmp8   = V[i-1][j] - V[i][j];
	  duvdx  = 0.25/dx * ( (tmp1*tmp2 - tmp3*tmp4) + alpha * (tmp5*tmp6 - tmp7*tmp8) );
	  
	  tmp1   = V[i][j] + V[i][j+1];
	  tmp2   = V[i][j-1] + V[i][j];
	  tmp3   = fabs(tmp1);
	  tmp4   = V[i][j] - V[i][j+1];
	  tmp5   = fabs(tmp2);
	  tmp6   = V[i][j-1] - V[i][j];
	  dv2dy  = 0.25/dy * ( (tmp1*tmp1 - tmp2*tmp2) + alpha * (tmp3*tmp4 - tmp5*tmp6) );
	  
	  G[i][j] = V[i][j] + dt *
	    ( 1/Re * (d2vdx2 + d2vdy2) - duvdx - dv2dy + GY );
	}

	else G[i][j] = V[i][j];
      }

    }
}


void calculate_rs(double dt,
		 double dx,
		 double dy,
		 int imax,
		 int jmax,
		 double **F,
		 double **G,
		 double **RS)
{
  int i,j;
  for(i=1;i<=imax;i++)
    for(j=1;j<=jmax;j++)
      RS[i][j] = ( (F[i][j] - F[i-1][j]) / dx +
		   (G[i][j] - G[i][j-1]) / dy ) / dt;
}

void sor(int itermax,
	 double eps,
	 double omg,
	 double dx,
	 double dy,
	 double dp,
	 int imax,
	 int jmax,
	 double **P,
	 double **RS,
	 int **Flag,
	 double *res)
{
  int i,j,f;
  double a,b,r;

  a = 1.0/(dx*dx);
  b = 1.0/(dy*dy);


  for(i=0;i<=imax+1;i++){
    for(j=0;j<=jmax+1;j++){

      f = Flag[i][j];
//      printf("Debug: i=%d   j=%d\n",i,j);
//      fflush(stdout);

      if( (f&C_TYP) == C_F ){ // fluid cells
	P[i][j] = (1.0-omg) * P[i][j] +
	  omg/(2*(a + b))*( (P[i+1][j] + P[i-1][j])*a +
			    (P[i][j+1] + P[i][j-1])*b - RS[i][j]);
      }
      else if( (f&C_TYP) == C_B ){ // boundary and obstacle cells
        if     ( f&C_dW ) P[0][j] = 2.*dp-P[1][j];
	else if( f&C_dO ) P[imax+1][j] = 0.0-P[imax][j];
        else if(      (f&C_H) == C_N     )  P[i][j] = P[i][j+1];
	else if(      (f&C_H) == C_S     )  P[i][j] = P[i][j-1];
	else if(      (f&C_H) == C_W     )  P[i][j] = P[i-1][j];
	else if(      (f&C_H) == C_O     )  P[i][j] = P[i+1][j];
	else if(      (f&C_H) == C_NO    )  P[i][j] = (P[i][j+1]+P[i+1][j])/2;
	else if(      (f&C_H) == C_NW    )  P[i][j] = (P[i][j+1]+P[i-1][j])/2;
	else if(      (f&C_H) == C_SO    )  P[i][j] = (P[i][j-1]+P[i+1][j])/2;
	else if(      (f&C_H) == C_SW    )  P[i][j] = (P[i][j-1]+P[i-1][j])/2;
	else if(      (f&C_H) == 0       )  P[i][j] = 0;
      }
    }
  }

//  printf("Calculate Residuum\n");
//  fflush(stdout);

  (*res) = 0.0;
  for(i=1;i<=imax;i++){
    for(j=1;j<=jmax;j++){

      f = Flag[i][j];

      if( (f&C_TYP) == C_F ){ // Residuum in fluid cells

	r =  (P[i+1][j  ] - 2*P[i][j] + P[i-1][j  ])*a +
	     (P[i  ][j+1] - 2*P[i][j] + P[i  ][j-1])*b - RS[i][j];
	(*res) += r*r;

      }
      else if( (f&C_TYP) == C_B ){ // Residuum in boundary and obstacle cells
	if( (f&C_TYP)==C_B ){

	  if(           (f&C_H) == C_N     )  r = P[i][j] - P[i][j+1];
	  else if(      (f&C_H) == C_S     )  r = P[i][j] - P[i][j-1];
	  else if(      (f&C_H) == C_W     )  r = P[i][j] - P[i-1][j];
	  else if(      (f&C_H) == C_O     )  r = P[i][j] - P[i+1][j];
	  else if(      (f&C_H) == C_NO    )  r = P[i][j] - (P[i][j+1]+P[i+1][j])/2;
	  else if(      (f&C_H) == C_NW    )  r = P[i][j] - (P[i][j+1]+P[i-1][j])/2;
	  else if(      (f&C_H) == C_SO    )  r = P[i][j] - (P[i][j-1]+P[i+1][j])/2;
	  else if(      (f&C_H) == C_SW    )  r = P[i][j] - (P[i][j-1]+P[i-1][j])/2;
	  else if(      (f&C_H) == 0       )  r = P[i][j] - 0;
	}
	(*res) += r*r;
      }
    }
  }

  (*res) = sqrt( (*res)/(imax*jmax) );
//  printf("%f\n",(*res));
}




void calculate_dt(double Re,
		 double tau,
		 double *dt,
		 double dx,
		 double dy,
		 int imax,
		 int jmax,
		 double **U,
		 double **V)
{
  int i,j;
  double uabs,vabs;
  double umax, vmax;
  double a,b,c;
  a = Re*0.5/(1.0/(dx*dx) + 1.0/(dy*dy));
  umax = 0.0;
  vmax = 0.0;
  for(i=0;i<=imax;i++){
    for(j=0;j<=jmax+1;j++){
      uabs = fabs(U[i][j]);
      if(uabs > umax) umax = uabs;
    }
  }
  for(i=0;i<=imax+1;i++){
    for(j=0;j<=jmax;j++){
      vabs = fabs(V[i][j]);
      if(vabs > vmax) vmax = vabs;
    }
  }
  if(umax > 0.0)
    b = dx/umax;
  else 
    b = 1.0e30;
  if(vmax > 0.0)
    c = dy/vmax;
  else 
    c = 1.0e30;
//  printf("umax = %f    vmax = %f    a = %f    b = %f     c= %f\n",umax,vmax,a,b,c);
  (*dt) = tau * fmin( a, fmin ( b,c ));
}


void calculate_uv(double dt,
		 double dx,
		 double dy,
		 int imax,
		 int jmax,
		 double **U,
		 double **V,
		 double **F,
		 double **G,
		 double **P,
		 int **Flag)
{
  int i,j;

  for(i=1;i<=imax-1;i++)
    for(j=1;j<=jmax;j++){
      if(  (Flag[i][j]&C_TYP) == C_F  && (Flag[i][j]&C_O) == C_O ){
        U[i][j] = F[i][j] - dt/dx*(P[i+1][j] - P[i][j]);
      }
      else U[i][j] = 0;
    }
  printf("U[10][10]: %f\n",U[10][10]);
  for(i=1;i<=imax;i++)
    for(j=1;j<=jmax-1;j++){
      if(  (Flag[i][j]&C_TYP) == C_F  && (Flag[i][j]&C_N) == C_N ){
        V[i][j] = G[i][j] - dt/dy*(P[i][j+1] - P[i][j]);
      }
      else V[i][j] = 0;
    }

}

