#ifndef __UVP_H__
#define __VISUAL_H__

struct element{
  double x; double y; struct element *zeiger_vor; struct element *zeiger_zurueck;
};
typedef struct element listenelement;

void output_uvp(const char *szProblem,
		 double xlaenge,
                 double ylaenge,
                 int    imax,
                 int    jmax,
		 double dx,
		 double dy,
                 double **U,
                 double **V,
                 double **P,
		 int **Flag);

void calculate_psi_zeta(double dx,
		       double dy,
		       int imax,
		       int jmax,
		       double **U,
		       double **V,
		       double **Psi,
		       double **Zeta );

void write_fieldfile( const char *szProblem, int imax, int jmax, 
                      double xlength, double ylength, int nCount );

struct particle{
  double x,y;
  struct particle *next;
};

struct particle_line{
  int length;
  struct particle *Particle;
};


struct particle_line *set_particle(int N, 
				      double x1, 
				      double y1, 
				      double x2, 
				      double y2,
				      double xlength,
				      double ylength,
				      char *Outputfile);

void move_particle(struct particle_line *Particle_Lines, 
		     int N, 
		     double dt, 
		     double dx, 
		     double dy, 
		     int imax, 
		     int jmax, 
		     double **U, 
		     double **V,
		     int **Flag);

void insert_particle(struct particle_line *Particle_Lines, 
			int N);

void write_particle(struct particle_line *Particle_Lines, 
		       int N, 
		       int partmax, 
		       char* Outputfile);

void pathlines(struct particle_line *Partline, 
		int N, 
		double dt_path, 
		double t, 
		double dx, 
		double dy, 
		double dt, 
		int imax, 
		int jmax, 
		double **U, 
		double **V,
		int **Flag,
		char* Outputfile); 

void streaklines(struct particle_line *Particle_Lines, 
		   int N, 
		   double dt_einfuege, 
		   double dt_streak, 
		   double t, 
		   double dx, 
		   double dy, 
		   double dt, 
		   int imax, 
		   int jmax, 
		   double **U, 
		   double **V, 
		   int **Flag,
		   char* Outputfile);

void write_particlefieldfile(char *outputfile,
                   int partmax, int nCount);
#endif
