/*
program name solvesys.c

program usage:
./exec_name file_matrix file_rhs maximum_nr_of_iterations eps

example:
./exec_name data/a30.txt data/rhs30.txt 100 1.e-6
*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// #define PRINT_ALL

void deleteRhs(double *rhs);
void deleteMatrix(double **a, int nx);
void printMatrix(double ** a, int n, int m);
double* loadRhs(char* filename);
double** loadMatrix(char* filename, int *nx, int *ny);
void solveJacobi(double** a, double* rhs, double* x0, double* x, int n, int maxiter, double eps);


int main(int argc, char** argv){

	char* fileMatrix;
	char* fileRhs;
	int maxiter;
	double eps;

	int i;
	int nx = 0, ny = 0;
	double** a;
	double* rhs;
	int option = 0;

	/*parse the input parameters*/
	fileMatrix = argv[1];
	fileRhs = argv[2];
	maxiter = atoi(argv[3]);
	eps = atof(argv[4]);

	/*load matrix*/
	a = loadMatrix(fileMatrix, &nx, &ny);
	printf("Finished loading the matrix: nx = %d ny = %d\n", nx, ny);
	/*load rhs*/
	rhs = loadRhs(fileRhs);
	printf("Finished loading the rhs.\n");

	/*call the solver*/
	double *x, *x0;
	x = malloc(nx*sizeof(double));
	x0 = malloc(nx*sizeof(double));

	/*initialize start solution*/
	for (i=0; i<nx; i++){
		x0[i] = 0.0;
	}

	printf("Solving the SLE with Jacobi iteration\n");
	solveJacobi(a, rhs, x0, x, nx, maxiter, eps);

	/*free the memory*/
	free( x);
	free( x0);
	deleteRhs(rhs);
	deleteMatrix(a, nx);
	return 0;
}

/*solve the SLE a*x=rhs, with the initial solution x0*/
void solveJacobi(double** a, double* rhs, double* x0, double* x, int n, int maxiter, double eps){

}

double* loadRhs(char* filename){
	
	/*read rhs dimensions*/
	int nx = 0, i;
	double *a, val;
	FILE* f;

	if ((f = fopen(filename, "r")) == NULL) {
		fprintf(stderr, "Cannot open file %s.", filename);
		exit(1);
	}

	fscanf(f, "%d\n", &nx);
	printf("NX = %d \n", nx);

	/*allocate the matrix*/
	a = malloc(nx*sizeof(double));
	for (i = 0; i<nx; i++){
		fscanf(f, "%lg\n", &val);
		a[i] = val;
	}

	fclose(f);
	return a;
}

void deleteRhs(double *rhs){
	if (rhs!=NULL)
		free(rhs);
}

double** loadMatrix(char* filename, int *nx, int *ny){
	int total, i;
	double val;
	int ix, iy;

	FILE *f;
	double** a;

	if ((f = fopen(filename, "r")) == NULL) {
		fprintf(stderr, "Cannot open file %s.", filename);
		exit(1);
	}
	
	//read matrix dimensions
	fscanf(f, "%d %d %d\n", nx, ny, &total);
	printf("NX = %d \tNY = %d \tTotal = %d\n", *nx, *ny, total);

	//allocate matrix
	a = (double **) malloc((*nx)*sizeof(double*));
	for (i = 0; i<*nx; i++)
		a[i] = (double*) malloc((*ny)*sizeof(double));

	//read values from file
	for (i = 0; i<total; i++){
        fscanf(f, "%d %d %lg\n", &ix, &iy, &val);
		a[ix-1][iy-1] = val;
	}
	fclose(f);
	return a;
}

void deleteMatrix(double **a, int nx){
	int i;
	for (i = 0; i<nx;i++)
		free(a[i]);
	free(a);
}
